# Add Document Tracking (example of how to add a new Report Type)
# 040702 - first draft of program
# 040713 - added document Date, removed "xx" prefixes from names
# 060211 - Alex - use the helper functions in Data.py
# 060828 - Brian - add default report layout for followup items

# Will add a new table to the data base and a new report type.
# See the script "Add Percent Complete" for an example how to add new additional
#   column types later.

# This script must be run against each file to include the new report options.

# The following will add a new Table and Report Type named "Document"
#   that can be used to store the URL's for project documentation.

# If you want to make sure the report types and column types you add don't conflict
#    with new releases of GanttPV, prefix the Name with "xx". For
#    example: "xxDocument", "xxOwner", "xxURL", etc.

def DoAdd():
    rt = { 'Name': 'Document', 'TableA': 'Document', 'AllOrEach': 'both',
            'SuggestedColumns': ',ID;,Name;,Date;,Owner;,URL' }
    ct = [
    { 'Name': 'ProjectID',    'Label': 'Project\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'Project/Name', 'Label': 'Project\nName',  'DataType': 't', 'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 100  },
    { 'Name': 'ID', 'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False  },
    { 'Name': 'Name', 'Label': 'Name', 'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True, 'Width': 140 },
    { 'Name': 'Date', 'Label': 'Date', 'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True, 'Width': 80 },
    { 'Name': 'Owner', 'Label': 'Owner', 'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True, 'Width': 140 },
    { 'Name': 'URL', 'Label': 'URL', 'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True, 'Width': 140 },
        ]
    Data.AddReportType(rt, ct)
    Data.SetUndo("Install Document Tracking")

DoAdd()
